﻿<%@ register tagprefix="eb" namespace="Soneta.Core.Web" assembly="Soneta.Core.Web" %>
<%@ register tagprefix="ea" namespace="Soneta.Web" assembly="Soneta.Web" %>
<%@ import namespace="Soneta.Business.Db" %>
<%@ import namespace="Soneta.CRM" %>
<%@ Import Namespace="Soneta.Deklaracje.VAT" %>
<%@ import namespace="Soneta.Tools" %>
<%@ import namespace="Soneta.Types" %>
<%@ import namespace="Soneta.Business" %>
<%@ import namespace="Soneta.Magazyny" %>
<%@ import namespace="Soneta.Handel" %>
<%@ import namespace="Soneta.Towary" %>

<%@ page language="c#" autoeventwireup="false" codepage="1200" %>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<html>
<head>
    <title>Stany magazynowe</title>
    <meta content="C#" name="CODE_LANGUAGE">
    <meta content="JavaScript" name="vs_defaultClientScript">
    <meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
</head>
<script runat="server">
	 
    public class ParametryContext : ContextBase {

        public ParametryContext(Context cx)
            : base(cx) {
        }

        FeatureDefinition cechaTowaru;

        [Priority(40)]
        [Caption("Cecha pozycji")]
        [Required]
        public FeatureDefinition CechaPozycji {
            get { return cechaTowaru; }
            set { 
                cechaTowaru = value; 
                OnChanged(EventArgs.Empty); 
            }
        }

        public object GetListCechaPozycji() {
            RowCondition rc = new FieldCondition.Equal("TableName", "PozycjeDokHan");
            rc &= new FieldCondition.In("TypeNumber", FeatureTypeNumber.Tree, FeatureTypeNumber.String);
            rc &= new FieldCondition.NotEqual("Dictionary", String.Empty);
            return BusinessModule.GetInstance(this).FeatureDefs.ByName[rc];
        }
    }

    [Context]
    public ParametryContext Parametry { get; set; }

    public class Rekord {

            readonly string _wartoscCechy;

            public Rekord(string wartoscCechy, decimal wartość) {
                _wartoscCechy = wartoscCechy;
                _wartość = wartość;
            }

            public string WartoscCechy {
                get { return _wartoscCechy; }
            }

            private decimal _wartość;

            public decimal Wartosc {
                get { return _wartość; }
            }

            public void Add(decimal wart){
                _wartość += wart;
            }
            	
        }      
	 
        protected void dc_ContextLoad(object sender, EventArgs e) {
            var op = dc.Context[typeof(ObrotyParams), false] as ObrotyParams;
            if (op == null) return;

        	if (op.DataStanu != op.Okres.Okres.To && op.DataStanu != Date.Empty)
				throw new InvalidOperationException("Szczegółowy raport stanu magazynowego może być robiony tylko według stanu aktualnego oraz na koniec okresu magazynowego.");

            string magazyny_ = "";
            var magazyny = new ArrayList();
            foreach (Magazyn magazyn in op.Magazyny) {
                MagazynyModule mm;
                magazyny.Add(magazyn);
                magazyny_ += magazyn.Nazwa.Replace("&", "&amp;") + ", ";
            }

            magazyny_ = magazyny_.Trim(new[] { ',', ' '});            
            ReportHeader.Title = String.Format("Stany magazynowe wg cechy|</STRONG><strong>Nazwa cechy:{0}|</strong>Okres magazynowy:<STRONG> {1}|</STRONG>Magazyn:<STRONG> {2}|</STRONG>", Parametry.CechaPozycji.Name, op.Okres, magazyny_);            

            RowCondition cond = new FieldCondition.Equal("Partia.Typ", TypPartii.Magazynowy);
            cond &= new FieldCondition.Equal("Okres", op.Okres);
            if(magazyny.Count==1)
                cond &= new FieldCondition.Equal("Magazyn", op.Magazyn);
            if(magazyny.Count>1)
                cond &= new FieldCondition.In("Magazyn", op.Magazyny);

            var dict = new System.Collections.Generic.Dictionary<string, Rekord>();
            foreach(Zasob zasob in MagazynyModule.GetInstance(op.Session).Zasoby.WgTowar[cond]) {
                var feature = zasob.Partia.Pozycja.Features[Parametry.CechaPozycji.Name].ToString();
                Rekord rekord;
                if(dict.TryGetValue(feature, out rekord))
                    rekord.Add(zasob.Partia.Wartosc);                
                else
                    dict.Add(feature, new Rekord(feature, zasob.Partia.Wartosc));                
            }
            WartoscCechyId.Caption = "Wartość cechy ("+Parametry.CechaPozycji.Name+")";
            Grid.DataSource = dict.Values;

        } 

        
</script>
<body>
    <form method="post" runat="server">
        <ea:datacontext id="dc" runat="server" oncontextload="dc_ContextLoad"></ea:datacontext>
        <eb:reportheader id="ReportHeader" runat="server" title="Stany magazynowe|</STRONG>"></eb:reportheader>
        <ea:grid id="Grid" runat="server">
				<Columns>
                    <ea:GridColumn runat="server" Align="Right" Caption="L.p." DataMember="#" Width="5"></ea:GridColumn>
					<ea:GridColumn Align="Left" ID="WartoscCechyId" DataMember="WartoscCechy" Caption="Wartość cechy" runat="server" EncodeHTML="True" Total="Info"></ea:GridColumn>
					<ea:GridColumn Width="16" Align="Right" DataMember="Wartosc" Caption="Wartość" Format="{0:n}" runat="server" Total="Sum"></ea:GridColumn>
				</Columns>
			</ea:grid>
        <eb:reportfooter id="ReportFooter" runat="server" printdate="true" printtime="true"></eb:reportfooter>
    </form>
</body>
</html>

